/*jslint node: true, nomen: true, unparam: true */
/*global jquery, _, $ */

'use strict';

require(["Portal", "jquery", "Router", "Controller", "core/utilities/errorHandling", "core/utilities/loadingSpinner", "core/utilities/authentication", "core/utilities/scrollableZones", "core/utilities/selectMenu", "core/utilities/ScrollList", "core/utilities/jqmPopupFix", "core/utilities/accessiblePanel", "backbone", "marionette", "jquerymobile"],
    function (Portal, $, Router, Controller, errorHandling, loadingSpinner, authentication, scrollableZones, selectMenu, ScrollList, jqmPopupFix, accessiblePanel) {

        function loadResourceDirectory() {
            authentication.fixIEOrigin();
            var deferred = $.Deferred(),
                location = window.location,
                prodPath = location.origin,
                devPath = location.protocol + '//' + location.hostname + ':8080', //Given services are running in tomcat
                path = prodPath,
                servicesPath = '/PatientViewerServices/rest/public/resource-directory';

                if (location.hostname === 'localhost' && location.port !== '8080'){
                    path = devPath;
                }
                path = path+servicesPath;

            Portal.resources().fetch({
                url: path
            })
                .done(function (response) {
                    Portal.vent.trigger("load:resources");
                    deferred.resolve(response);
                    if (console && console.log) {
                        console.log('Loaded resources from path=' + path);
                    }
                })
                .fail(function () {
                    deferred.reject();
                    if (console && console.log) {
                        console.log('Failed to load resources from path=' + path);
                    }
                });

            return deferred.promise();
        }

        function fetchPackageDataDefinedByApp() {
            var deferred = $.Deferred();

            // check app level for applet info first
            Portal.packageData().fetch({ url: '../version.json', global: false})
                .done(function (response) {
                    if (response.applets) {
                        deferred.resolve(response);
                    } else {
                        deferred.reject();
                    }
                })
                .fail(function () {
                    if (console && console.log) {
                        console.log('Failed to resolve version.json at the app level. Defaulting to version.json at the container level...');
                    }
                    deferred.reject();
                });

            return deferred.promise();
        }

        function loadPackageData() {
            var deferred = $.Deferred();

            fetchPackageDataDefinedByApp()
                .done(function (response) {
                    deferred.resolve(response);
                })
                .fail(function () {

                    // if container is not part of an app, use mock applets data in container level version.json
                    Portal.packageData().fetch({ url: 'version.json'})
                        .done(function (response) {
                            if (console && console.log) {
                                console.log('Resolved version.json at the container level');
                            }
                            if (typeof response['uber-portal'] !== 'undefined' && response['uber-portal']){
                                Portal.uber = true;
                            }
                            deferred.resolve(response);
                        })
                        .fail(function () {
                            if (console && console.log) {
                                console.log('Failed to resolved version.json at the container level');
                            }
                            deferred.reject();
                        });
                });

            return deferred.promise();
        }

        function appletPathList(applets) {
            var list = [];
            _.each(applets, function (applet) {
                list.push('applets/' + applet.name + '/loader');
            });
            return list;
        }

        function widgetNames(widgets) {
            var list = [];
            if ( typeof widgets !== 'undefined' ) {
                _.each(widgets, function (widget) {
                    list.push(widget.name);
                });
            }
            return list;
        }

        function showLoading(){
            $("body").append('<div class="loaderModalMask"/>');
            $.mobile.loading('show', {
                text: 'Loading',
                textVisible: true,
                theme: 'a',
                html: ""
            });
        }

        function hideLoading(){

        }

        $.mobile.linkBindingEnabled = false;
        $.mobile.hashListeningEnabled = false;

        errorHandling.setupAjaxErrorHandling();
        loadingSpinner.show(true);
        scrollableZones.register();
        jqmPopupFix.register();
        accessiblePanel.register();

        Portal.scrollableZoneHeight = scrollableZones.calculateHeight;
        Portal.scrollList = ScrollList.build;

        selectMenu.register();

        Portal.router = new Router({
            controller: new Controller()
        });

        // Load links, applets and resource directory
        $.when(loadPackageData(), loadResourceDirectory())
            .then(function (packageData) {
                authentication.authenticate().done(function () {
                    Portal.widgets = widgetNames(packageData.widgets);
                    Portal.staff().fetch({
                        url: Portal.resources().get('mhpuser').get('href')
                    }).done(function (response) {
                        Portal.vent.trigger("load:staff");
                        _.each(packageData.links, function(item){
                            Portal.vent.trigger("add:link", item);
                        });
                        Portal.patient().fetch({
                            url: Portal.staff().get('user-context').get('href')
                        }).done(function () {
                            // may start portal without patient in context
                            if (!Portal.patient().isEmpty()) {
                                Portal.vent.trigger("load:patient");
                            }
                            var pathList = appletPathList(packageData.applets),
                                loadApplets = function () {
                                    require(pathList, function () {
                                        Portal.start();
                                        loadingSpinner.hide();
                                        loadingSpinner.register();

                                    }, function (err) {
                                        if (console && console.log) {
                                            console.log('Error loading applet, message: ' + err.message);
                                        }
                                        var failedLoad = err.requireModules && err.requireModules[0];
                                        requirejs.undef(failedLoad);
                                        pathList = _.without(pathList, failedLoad);
                                        loadApplets();
                                    });
                                };
                            loadApplets();

                        });
                    });
                });
            })
            .fail(function () {
                Portal.vent.trigger('error', {
                    message: 'Unable to initialize the application. Check connections or try again later.'
                });
            });
    });